/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1074;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2203;
import net.minecraft.class_2338;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtDataGetPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public NbtDataGetPlaceholder() {
        super("nbt_data_get");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String sourceType = dps.values.get("source_type");
        String nbtPath = dps.values.get("nbt_path");
        String scaleStr = dps.values.get("scale");
        String returnType = dps.values.get("return_type");
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return "";
        }
        if (sourceType == null || nbtPath == null) {
            return "";
        }
        if (returnType == null || returnType.isEmpty()) {
            returnType = "value";
        }
        try {
            class_2203.class_2209 path = class_2203.class_2209.method_58472((String)nbtPath);
            class_2487 sourceData = this.getSourceData(sourceType, dps);
            if (sourceData == null) {
                return "";
            }
            List tags = path.method_9366((class_2520)sourceData);
            if (tags.isEmpty()) {
                return "";
            }
            class_2520 tag = (class_2520)tags.get(0);
            if ("string".equalsIgnoreCase(returnType)) {
                return this.getTagAsString(tag);
            }
            if ("snbt".equalsIgnoreCase(returnType)) {
                return tag.toString();
            }
            if ("json".equalsIgnoreCase(returnType) && tag instanceof class_2487) {
                class_2561 component = class_2512.method_32270((class_2520)tag);
                String json = ((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)level.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)component).getOrThrow()).toString();
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = json.substring(1, json.length() - 1);
                }
                return json;
            }
            double scale = 1.0;
            if (scaleStr != null && !scaleStr.isEmpty()) {
                try {
                    scale = Double.parseDouble(scaleStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.getTagValue(tag, scale);
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error in nbt_data_get placeholder: " + e.getMessage());
            return "";
        }
    }

    private class_2487 getSourceData(String sourceType, DeserializedPlaceholderString dps) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        switch (sourceType.toLowerCase()) {
            case "entity": {
                return this.getEntityData(dps);
            }
            case "block": {
                return this.getBlockData(dps);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private class_2487 getEntityData(DeserializedPlaceholderString dps) {
        String selector = dps.values.get("entity_selector");
        if (selector == null) {
            return null;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (player == null || level == null) {
            return null;
        }
        class_746 targetEntity = null;
        block6 : switch (selector) {
            case "@s": 
            case "@p": {
                targetEntity = player;
                break;
            }
            case "@e": {
                double nearestDist = Double.MAX_VALUE;
                for (class_1297 entity : level.method_18112()) {
                    double dist = entity.method_5858((class_1297)player);
                    if (!(dist < nearestDist)) continue;
                    nearestDist = dist;
                    targetEntity = entity;
                }
                break;
            }
            default: {
                try {
                    UUID uuid = UUID.fromString(selector);
                    for (class_1297 entity : level.method_18112()) {
                        if (!entity.method_5667().equals(uuid)) continue;
                        targetEntity = entity;
                    }
                    break;
                }
                catch (IllegalArgumentException e) {
                    for (class_1297 entity : level.method_18112()) {
                        if (!entity.method_5477().getString().equals(selector)) continue;
                        targetEntity = entity;
                        break block6;
                    }
                }
            }
        }
        if (targetEntity == null) {
            return null;
        }
        class_11362 valueOutput = class_11362.method_71458((class_8942)class_8942.field_60348);
        targetEntity.method_5647((class_11372)valueOutput);
        return valueOutput.method_71475();
    }

    private class_2487 getBlockData(DeserializedPlaceholderString dps) {
        String posStr = dps.values.get("block_pos");
        if (posStr == null) {
            return null;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        try {
            int z;
            int y;
            String[] parts = posStr.trim().split("\\s+");
            if (parts.length != 3) {
                return null;
            }
            int x = Integer.parseInt(parts[0]);
            class_2338 pos = new class_2338(x, y = Integer.parseInt(parts[1]), z = Integer.parseInt(parts[2]));
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity != null) {
                return blockEntity.method_38244((class_7225.class_7874)level.method_30349());
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("[FANCYMENU] Invalid block position: " + posStr);
        }
        return null;
    }

    private String getTagAsString(class_2520 tag) {
        if (tag instanceof class_2519) {
            class_2519 stringTag = (class_2519)tag;
            return stringTag.comp_3831();
        }
        if (tag instanceof class_2514) {
            return tag.toString();
        }
        return tag.toString();
    }

    private String getTagValue(class_2520 tag, double scale) {
        if (tag instanceof class_2514) {
            class_2514 numericTag = (class_2514)tag;
            if (scale != 1.0) {
                return String.valueOf(class_3532.method_15357((double)(numericTag.method_10697() * scale)));
            }
            return String.valueOf(class_3532.method_15357((double)numericTag.method_10697()));
        }
        if (tag instanceof class_2519) {
            class_2519 stringTag = (class_2519)tag;
            return String.valueOf(stringTag.comp_3831().length());
        }
        if (tag instanceof class_2483) {
            class_2483 collectionTag = (class_2483)tag;
            return String.valueOf(collectionTag.size());
        }
        if (tag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)tag;
            return String.valueOf(compoundTag.method_10546());
        }
        return this.getTagAsString(tag);
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("source_type", "entity_selector", "block_pos", "nbt_path", "scale", "return_type");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.nbt_data_get", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.nbt_data_get.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("source_type", "entity");
        values.put("entity_selector", "@s");
        values.put("block_pos", "");
        values.put("nbt_path", "foodLevel");
        values.put("scale", "1.0");
        values.put("return_type", "value");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

